/* This simple program demonstrates the input output capabilities of the aic23 codec included on the C6416 board.  
This program reads data in from the left and right channels and then sends the data out to the respective outputs. */


#include "C6416_DSK_INOUTcfg.h"

#define CHIP_6416 1


#include "dsk6416.h"
#include "dsk6416_aic23.h"



/* Codec configuration settings */
DSK6416_AIC23_Config config = { \
    0x0017,  /* 0 DSK6416_AIC23_LEFTINVOL  Left line input channel volume */ \
    0x0017,  /* 1 DSK6416_AIC23_RIGHTINVOL Right line input channel volume */\
    0x01f9,  /* 2 DSK6416_AIC23_LEFTHPVOL  Left channel headphone volume */  \
    0x01f9,  /* 3 DSK6416_AIC23_RIGHTHPVOL Right channel headphone volume */ \
    0x0011,  /* 4 DSK6416_AIC23_ANAPATH    Analog audio path control */      \
    0x0000,  /* 5 DSK6416_AIC23_DIGPATH    Digital audio path control */     \
    0x0000,  /* 6 DSK6416_AIC23_POWERDOWN  Power down control */             \
    0x0043,  /* 7 DSK6416_AIC23_DIGIF      Digital audio interface format */ \
    0x0081,  /* 8 DSK6416_AIC23_SAMPLERATE Sample rate control */            \
    0x0001   /* 9 DSK6416_AIC23_DIGACT     Digital interface activation */   \
};

void main()
{
    DSK6416_AIC23_CodecHandle hCodec;
    Int16 OUT_L,OUT_R;
    Uint32 IN_L,IN_R;
 	Uint32 value_of_the_sampling_rate;
    
    /* Initialize the board support library, must be called first */
    DSK6416_init();

     
    /* Start the codec */
    hCodec = DSK6416_AIC23_openCodec(0, &config);

	// Set codec frequency to 48KHz
	DSK6416_AIC23_setFreq(hCodec, DSK6416_AIC23_FREQ_8KHZ );
	//This checks reg 8 of the AIC
	value_of_the_sampling_rate = DSK6416_AIC23_rget(hCodec, 8);
	while (1)
	{
   
            // Read sample from the left channel 
           while (!DSK6416_AIC23_read(hCodec, &IN_L));

            // Read sample from the right channel 
          while (!DSK6416_AIC23_read(hCodec, &IN_R));
           
   
    		OUT_L=IN_L;
    		OUT_R=IN_R;
  
            /* Send a sample to the left channel */
         while (!DSK6416_AIC23_write(hCodec, OUT_L));

            /* Send a sample to the right channel */
         while (!DSK6416_AIC23_write(hCodec, OUT_R));
 
   
	}  

 	/* Close the codec */
    DSK6416_AIC23_closeCodec(hCodec);  
}
